﻿using Yamutec.Core.Utils;
using Yamutec.DemoUSBConsole;
using Yamutec.USB;
using Yamutec.USB.Devices;

var sigintReceived = false;

var cts = new CancellationTokenSource();

Screen.WriteScreen();

USBDevice currentDevice = null;

var options = new USBDevicesServerOptions
{
	ReadAllDevicesInterval = 100,

	DeviceConnectedCallback = (device) =>
	{
		//Console.WriteLine("device connected: " + device.Name);

		return Task.CompletedTask;
	},

	DeviceDisconnectedCallback = (device) =>
	{
		//Console.WriteLine("device disconnected: " + device.Name);

		return Task.CompletedTask;
	},

	DevicesChangedCallback = (connetedDevices, disconnectedDevices, currentConnectedDevices) =>
	{
		var devices = currentConnectedDevices.OrderBy(x => x.Name).ThenBy(x => x.SerialNumber).ToList();

		Screen.WriteDevices(devices, currentDevice);

		return Task.CompletedTask;
	},

	ReadCallback = (device, readData) =>
	{
		//Console.WriteLine("data read: " + device.Name);

		if (currentDevice == device)
		{
			Screen.WriteDeviceBits(readData.OutputBits, readData.InputBits);
			Screen.WriteTimeout(readData.TimeoutActive, readData.TimeoutTriggered);
		}

		return Task.CompletedTask;
	}
};


var server = new USBDevicesServer(options);


void SelectDevice(int index)
{
	currentDevice = null;

	var devices = server.GetAllDevices();

	devices = devices.OrderBy(x => x.Name).ThenBy(x => x.SerialNumber).ToList();

	if (index >= 0 && index < devices.Count)
	{
		currentDevice = devices[index];
	}

	Screen.WriteDevices(devices, currentDevice);
}


await server.StartAsync();


Console.CancelKeyPress += async (_, ea) =>
{
	// Tell .NET to not terminate the process
	ea.Cancel = true;

	if (!sigintReceived)
	{
		Screen.WriteAt(Screen.LastRow + 2, 0, "Received SIGINT (Ctrl+C), shutting down...");

		await server.StopAsync();

		cts.Cancel();

		sigintReceived = true;
	}
};


while (true)
{
	var keyInfo = await ConsoleUtils.ReadKeyAsync(true, 50, cts.Token);

	if (keyInfo == null)
	{
		break;
	}

	var shiftAndKeyPressed = ConsoleUtils.GetShiftAndFKey(keyInfo.Value);

	if (shiftAndKeyPressed != null)
	{
		switch (shiftAndKeyPressed.Value)
		{
			case ConsoleKey.F1:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.ActivateAllOutputsAsync();
					}
				});
				break;

			case ConsoleKey.F2:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.DeactivateAllOutputsAsync();
					}
				});
				break;

			case ConsoleKey.F3:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.ActivateOutputsAsync(new[] { 1, 3, 7 });
					}
				});
				break;


			case ConsoleKey.F4:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.DeactivateOutputsAsync(new[] { 1, 3, 7 });
					}
				});
				break;

			case ConsoleKey.F5:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.DeactivateTimeoutAsync();
					}
				});
				break;

			case ConsoleKey.F6:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.ActivateTimeoutAsync(5);
					}
				});
				break;

			case ConsoleKey.F7:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.ActivateTimeoutAsync(10);
					}
				});
				break;

			case ConsoleKey.F8:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.ActivateTimeoutAsync(15);
					}
				});
				break;

			case ConsoleKey.F9:
				_ = Task.Run(async () =>
				{
					if (currentDevice != null)
					{
						await currentDevice.RebootAsync();
					}
				});
				break;
		}
	}
	else
	{
		if (keyInfo.Value.Modifiers == 0)
		{
			var key = keyInfo.Value.Key;

			if (key >= ConsoleKey.D1 && key <= ConsoleKey.D9)
			{
				SelectDevice((int)key - 49);
			}
		}
	}
}

Screen.WriteAt(Screen.LastRow + 3, 0, "Good bye");