﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Yamutec.Core.Extensions;
using Yamutec.USB.Devices;

namespace Yamutec.DemoUSBConsole
{
	public static class Screen
	{
		private static int _leftColumns = 65;
		private static int _rightColumns = 63;

		public static int LastRow = 0;

		#region PrivateMethods


		private static void _Write(int row, int column, string text)
		{
			Console.SetCursorPosition(column, row++);
			Console.Write(text);
		}

		private static void _WriteLines(int row, int column, int padding, params string[] lines)
		{
			foreach (var line in lines)
			{
				Console.SetCursorPosition(column, row++);
				Console.Write(line.PadRight(padding));
			}
		}

		private static void _WriteLines(int row, int column, int padding, List<string> lines)
		{
			foreach (var line in lines)
			{
				Console.SetCursorPosition(column, row++);
				Console.Write(line.PadRight(padding));
			}
		}

		private static void _WriteLines(int row, int column, List<string> lines)
		{
			foreach (var line in lines)
			{
				Console.SetCursorPosition(column, row++);
				Console.Write(line);
			}
		}

		private static List<string> _GetBitsLines(string title, bool[] bits)
		{
			int length = (int)Math.Ceiling(bits.Length / 8m) + 1;

			var lines = new List<string>(length);

			lines.Add(title);

			int lineIdx = 1;

			int bitIdx = 0;

			var sb = new StringBuilder();

			int pos;

			for (; lineIdx < length; lineIdx++)
			{
				pos = 0;

				while (pos < 8 && bitIdx < bits.Length)
				{
					sb.Append("#" + (bitIdx + 1).ToString().PadLeft(2) + " " + (bits[bitIdx] ? "[x] " : "[ ] "));
					pos++;
					bitIdx++;
				}

				lines.Add(sb.ToString());

				sb.Clear();
			}

			return lines;
		}

		#endregion

		public static void WriteScreen()
		{
			Console.Clear();

			using (var stream = typeof(Screen).Assembly.GetManifestResourceStream("Yamutec.DemoUSBConsole.ScreenTemplate.txt"))
			{
				using (StreamReader reader = new StreamReader(stream))
				{
					string content = reader.ReadToEnd();
					WriteAt(0, 0, content);
					LastRow = content.Occurrences("\n");
				}
			}
		}

		public static void WriteDevices(List<USBDevice> devices, USBDevice currentDevice)
		{
			var lines = new List<string>();

			int n = 1;

			string selected;

			string deviceLine;

			foreach (var device in devices)
			{
				selected = currentDevice == device ? "x" : " ";

				deviceLine = $"[{selected}] {n} {device.Name} - addr: {device.Address} - sn: {device.SerialNumber}";

				lines.Add(deviceLine.Truncate(_leftColumns));

				n++;
			}

			if (devices.Count > 0)
			{
				lines.Add("");
				lines.Add(" * To set a device as active press the device number (1, 2, etc)");
			}

			for (int i = lines.Count; i < 17; i++)
			{
				lines.Add("");
			}

			_WriteLines(5, 2, _leftColumns, lines);
		}

		public static void WriteAt(int row, int column, in string content)
		{
			Console.SetCursorPosition(column, row);
			Console.Write(content);
		}

		public static void WriteDeviceBits(bool[] outputBits, bool[] inputBits)
		{
			var lines = new List<string>();

			if (outputBits != null)
			{
				var outputLines = _GetBitsLines("Output Bits:", outputBits);
				lines.AddRange(outputLines); ;
				lines.Add("");
			}

			if (inputBits != null)
			{
				var inputLines = _GetBitsLines("Input Bits:", inputBits);
				lines.AddRange(inputLines);
			}

			for (int i = lines.Count; i < 17; i++)
			{
				lines.Add("");
			}

			_WriteLines(4, _leftColumns + 5, _rightColumns, lines);
		}

		public static void WriteTimeout(bool timeoutActive, bool timeoutTriggered)
		{
			_Write(24, 2, $"Timeout active [{(timeoutActive ? "x" : " ")}]    Timeout triggered [{(timeoutTriggered ? "x" : " ")}]");
		}
	}
}
