# encoding=utf-8
import pdb
import threading
import signal
import sys
import time

from yamutec.utils import console
from yamutec import screen, DeviceServer
from keyboard import add_hotkey
#import curses
#curses.curs_set(0)

server = DeviceServer()

def signal_handler(sig, frame):
	server.stop()
	sys.exit(0)

signal.signal(signal.SIGINT, signal_handler)

def devices_changed_callback(connected_devices, disconnected_devices, current_connected_devices):
	screen.print_devices(current_connected_devices, server.current_device)


def read_devices_callback(device, read_data):
	if server.current_device and device.serial_number == server.current_device.serial_number:
		#print(read_data.output_bytes)
		screen.print_reading_output_inputs(read_data.output_bits, read_data.input_bits)
		screen.print_timeout(read_data.is_timeout_active, read_data.is_timeout_triggered)


def set_current_device(index):
	current_device = server.set_current_device(index)
	screen.print_devices(server.connected_devices, current_device)

	if current_device:
		read_data = current_device.read()

		if read_data:
			screen.print_reading_output_inputs(read_data.output_bits, read_data.input_bits)
			screen.print_timeout(read_data.is_timeout_active, read_data.is_timeout_triggered)
			return

	#clean outputs on screen
	screen.print_reading_output_inputs()
	screen.print_timeout()


def command_activate_all_outputs():
	current_device = server.current_device
	if current_device:
		current_device.activate_all_outputs()


def command_deactivate_all_outputs():
	current_device = server.current_device

	if current_device:
		current_device.deactivate_all_outputs()


def command_activate_outputs(outputs):
	current_device = server.current_device

	if current_device:
		current_device.activate_outputs(outputs)


def command_deactivate_outputs(outputs):
	current_device = server.current_device

	if current_device:
		current_device.deactivate_outputs(outputs)


def command_activate_timeout(to_value):
	current_device = server.current_device

	if current_device:
		current_device.change_timeout(True, to_value, 0, 0, 0, 0, 0, 0, 0, 0)

def command_deactivate_timeout():
	current_device = server.current_device

	if current_device:
		current_device.change_timeout(False)

def command_reboot():
	current_device = server.current_device

	if current_device:
		current_device.reboot()

for i in range(1, 10):
	add_hotkey('ctrl+' + str(i), set_current_device, args=[i - 1])


add_hotkey('ctrl+f1', command_activate_all_outputs, suppress=True)
add_hotkey('ctrl+f2', command_deactivate_all_outputs, suppress=True)
add_hotkey('ctrl+f3', command_activate_outputs, args=[[1, 3, 7]])
add_hotkey('ctrl+f4', command_deactivate_outputs, args=[[1, 3, 7]])

add_hotkey('ctrl+shift+1', command_deactivate_timeout)
add_hotkey('ctrl+shift+2', command_activate_timeout, args=[0])
add_hotkey('ctrl+shift+3', command_activate_timeout, args=[5])
add_hotkey('ctrl+shift+4', command_activate_timeout, args=[10])


add_hotkey('ctrl+R', command_reboot, suppress=True)





console.clear()


screen.print_header()
screen.print_devices()
screen.print_reading_output_inputs()
screen.print_timeout()
screen.print_commands()


server.devices_changed_callback = devices_changed_callback
server.read_devices_callback = read_devices_callback
server.read_alldevices_continously = True
server.read_alldevices_interval = 10

server.start()

try:
	while True:
		time.sleep(0.5)
finally:
	pass
	#curses.curs_set(1)
	#curses.endwin()
