from ctypes import Structure, LittleEndianStructure, \
    CFUNCTYPE, POINTER, addressof, sizeof, cast, \
    c_short, c_int, c_uint, c_size_t, c_long, \
    c_uint8, c_uint16, c_uint32, \
    c_void_p, c_char_p, py_object, pointer, c_char, c_ubyte, c_char_p, c_wchar_p, c_ushort

import pdb
import platform
import os.path
import sys
import ctypes.util


import atexit


_lib = None

def _loadLibrary():
	system = platform.system()
	prefix = ''
	if system == 'Windows':
		dll_loader = ctypes.WinDLL
		suffix = '.dll'
	else:
		prefix = 'lib'
		dll_loader = ctypes.CDLL
		if system == 'Darwin':
			suffix = '.dylib'
		else:
			suffix = '-libusb.so.0'
	loader_kw = {}
	if sys.version_info[:2] >= (2, 6):
		loader_kw['use_errno'] = True
		loader_kw['use_last_error'] = True


	try:
		return dll_loader(prefix + 'hidapi' + suffix, **loader_kw)
	except OSError:
		raise Exception('Library hidapi not found or could not load')


class hid_device_info(Structure):
	pass

hid_device_info_p = POINTER(hid_device_info)

#needs to be set after the class as pointers refers to itself

hid_device_info._fields_ =  [
 ('path', c_char_p),
 ('vendor_id', c_ushort),
 ('product_id', c_ushort),
 ('serial_number', c_wchar_p),
 ('release_number', c_ushort),
 ('manufacturer_string', c_wchar_p),
 ('product_string', c_wchar_p),
 ('usage_page', c_ushort),
 ('usage', c_ushort),
 ('interface_number', c_int),
 ('next', hid_device_info_p)
 ]  # yapf: disable


def _setup_prototypes(lib):
	lib.hid_init.argtypes = []
	lib.hid_init.restype = c_int
	lib.hid_exit.argtypes = []
	lib.hid_exit.restype = c_int
	lib.hid_enumerate.argtypes = [c_ushort, c_ushort]
	lib.hid_enumerate.restype = hid_device_info_p
	lib.hid_free_enumeration.argtypes = [hid_device_info_p]
	lib.hid_free_enumeration.restype = None
	lib.hid_open.argtypes = [c_ushort, c_ushort, c_wchar_p]
	lib.hid_open.restype = c_void_p
	lib.hid_open_path.argtypes = [c_char_p]
	lib.hid_open_path.restype = c_void_p
	lib.hid_write.argtypes = [c_void_p, c_char_p, c_size_t]
	lib.hid_write.restype = c_int
	lib.hid_read_timeout.argtypes = [c_void_p, c_char_p, c_size_t, c_int]
	lib.hid_read_timeout.restype = c_int
	lib.hid_read.argtypes = [c_void_p, c_char_p, c_size_t]
	lib.hid_read.restype = c_int
	lib.hid_set_nonblocking.argtypes = [c_void_p, c_int]
	lib.hid_set_nonblocking.restype = c_int
	lib.hid_send_feature_report.argtypes = [c_void_p, c_char_p, c_int]
	lib.hid_send_feature_report.restype = c_int
	lib.hid_get_feature_report.argtypes = [c_void_p, c_char_p, c_size_t]
	lib.hid_get_feature_report.restype = c_int
	lib.hid_close.argtypes = [c_void_p]
	lib.hid_close.restype = None
	lib.hid_get_manufacturer_string.argtypes = [c_void_p, c_wchar_p, c_size_t]
	lib.hid_get_manufacturer_string.restype = c_int
	lib.hid_get_product_string.argtypes = [c_void_p, c_wchar_p, c_size_t]
	lib.hid_get_product_string.restype = c_int
	lib.hid_get_serial_number_string.argtypes = [c_void_p, c_wchar_p, c_size_t]
	lib.hid_get_serial_number_string.restype = c_int
	lib.hid_get_indexed_string.argtypes = [c_void_p, c_int, c_wchar_p, c_size_t]
	lib.hid_get_indexed_string.restype = c_int
	lib.hid_error.argtypes = [c_void_p]
	lib.hid_error.restype = c_wchar_p


_lib = _loadLibrary()
_setup_prototypes(_lib)
