from . import _hidapi
import pprint
import pdb
import ctypes

_lib = _hidapi._lib

class _LibHID:
	def __init__(self):
		#pending, here I should initialize de lib
		pass

	def __del__(self):
		#pending, here I should release de lib
		pass


	def get_devices(self, vendor_id=0, product_id=0):
		ret = []

		first = _lib.hid_enumerate(vendor_id, product_id)
		info = first

		while info:
			ret.append(HIDDevice(info.contents))
			info = info.contents.next

		_lib.hid_free_enumeration(first)

		return ret

class HIDDevice(object):

	def __init__(self, device_info):
		self.path = device_info.path
		self.vendor_id = device_info.vendor_id
		self.product_id = device_info.product_id
		self.serial_number = device_info.serial_number
		self.release_number = device_info.release_number
		self.manufacturer_string = device_info.manufacturer_string
		self.product_string = device_info.product_string
		self.usage_page = device_info.usage_page
		self.usage = device_info.usage
		self.interface_number = device_info.interface_number

		self._ptr = None
		self._closing = False


	def open(self):
		self._ptr = _lib.hid_open_path(self.path)

	def read(self, size, timeout=None):
		data = ctypes.create_string_buffer(size)

		read = 0

		if timeout is None:
			read = _lib.hid_read(self._ptr, data, size)
		else:
			read = _lib.hid_read_timeout(self._ptr, data, size, timeout)

		if read > 0:
			return data.raw[:read]
		else:
			return None

	def write(self, data):
		return _lib.hid_write(self._ptr, data, len(data))

	def get_last_error(self):
		err = _lib.hid_error(self._ptr)
		pdb.set_trace()



	def close(self):
		if self._closing or not self._ptr:
			return

		self._closing = True

		_lib.hid_close(self._ptr)
		self._ptr = None


	def set_nonblocking(self, nonblock=1):
		_lib.hid_set_nonblocking(self._ptr, nonblock)


	def __del__(self):
		self.close()

	def __str__(self):
		return self.__repr__() + '\n' + pprint.pformat(vars(self), 5)

	def __repr__(self):
		return '<%s %s:%s instance at %s>' % (self.__class__.__name__, '%#0.4x' % (self.vendor_id), '%#0.4x' % (self.product_id), hex(id(self)))

LibHID = _LibHID()