import math
from .core import get_interval, pyVersion

class ReadData(object):
	def __init__(self, raw_data, device_output_bits, device_input_bits):
		
		input_index = 0
		output_bytes = None
		input_bytes = None

		self._raw_data = raw_data
		
		self._device_output_bits = device_output_bits
		self._device_input_bits = device_input_bits

		
		
		device_output_bytes = int(math.ceil(float(device_output_bits) / 8))
		device_inputs_bytes = int(math.ceil(float(device_input_bits) / 8))

		
		if device_output_bits > 0:
			output_bytes = self._get_bytes(raw_data, device_output_bytes, 0)
			input_index += device_output_bytes

		if device_inputs_bytes > 0:
			input_bytes = self._get_bytes(raw_data, device_inputs_bytes, input_index)


		self._output_bytes = output_bytes
		self._input_bytes = input_bytes
		
		#print(raw_data)
		#exit()

		if pyVersion == 2:
			self.reset = get_interval(ord(raw_data[9]))
			self.is_timeout_active = ord(raw_data[10]) == 1
			self.is_timeout_triggered = ord(raw_data[11]) == 1
		else:
			self.reset = get_interval(raw_data[9])
			self.is_timeout_active = raw_data[10] == 1
			self.is_timeout_triggered = raw_data[11] == 1
			

	def _get_bytes(self, raw_data, size, index):
		bs = bytearray(size)
		for i in range(0, size):
			bs[i] = raw_data[i + index]

		return bs

	@property
	def output_bytes(self):
		return self._output_bytes


	def _get_bits(self, raw_bytes, bits_count):
		bits = [False] * bits_count
		

		bit_index = 0

		for b in raw_bytes:
			i = 0
			while i < 8 and bit_index < bits_count:
				bits[bit_index] = (b & (1 << i)) > 0
				bit_index += 1
				i += 1
				
				
		return bits


	@property
	def output_bits(self):
		if self._output_bytes:
			return self._get_bits(self._output_bytes, self._device_output_bits)
		else:
			return None

	@property
	def input_bytes(self):
		return self._input_bytes

	@property
	def input_bits(self):

		if self._input_bytes:
			return self._get_bits(self._input_bytes, self._device_input_bits)
		else:
			return None