# encoding=utf-8
from .utils.console import print_at_lock
import pdb
import platform

_timeout_line_format = '│ Timeout active: [{}]   Timeout triggered: [{}]                                                                                   │'
_device_line_format = '│ [{}] {} - {} addr: {} sn:{}'
_outputs_format = '│ Output {:02} [{}]   Output {:02} [{}]   Output {:02} [{}]   Output {:02} [{}] │'
_inputs_format = '│ Input  {:02} [{}]   Input  {:02} [{}]   Input  {:02} [{}]   Input  {:02} [{}] │'


""" def print_at_lock(row, column, text):
	win.addstr(row, column, text)
	win.refresh() """


def print_header():
	print_at_lock(0, 0, '''\
┌────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
│ YAMUTEC - Smart Switch Systems V.1.01                                                                                          │
└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
┌────────────────────────────────────────────────────────────────┬───────────────────────────────────────────────────────────────┐
│ Devices:                                                       │                                                               │
''')

def print_devices(devices=None, active_device=None):
	row = 5
	num = 1

	if devices:
		for device in devices:
			#.name[0:7]
			line = _device_line_format.format(active_device and device.serial_number == active_device.serial_number and 'x' or ' ', num, device.name[0:7] +  device.name[9:], device.address, device.serial_number)
			print_at_lock(row, 0, '{0: <67}'.format(line))
			row += 1
			num += 1

	for row in range(row, 23):
		print_at_lock(row, 0, '│                                                                ')
		#row += 1

	print_at_lock(row, 0, '│ * To set a device as activate press CTRL + Device number')


def print_reading_output_inputs(output_bits=None, input_bits=None):
	row = 4

	if isinstance(output_bits, list):
		print_at_lock(row, 65, '│ Outputs from selected device:                                 │')
		row += 1
		bit_index = 0
		#pdb.set_trace()
		for row in range(row, row + (int(len(output_bits) / 4))):
			format_values = []
			#print('index: ' + str(bit_index))
			#print('to: ' + str(bit_index + 4))
			for bit_index in range(bit_index, bit_index + 4):
				#print('index: ' + str(bit_index))

				format_values.append(bit_index + 1)
				format_values.append(output_bits[bit_index] and 'x' or ' ')

			bit_index += 1

			#print(format_values)
			print_at_lock(row, 65, _outputs_format.format(*format_values))

		row += 1

		if isinstance(input_bits, list):
			print_at_lock(row, 65, '│                                                               │')
			row += 1

	if isinstance(input_bits, list):
		print_at_lock(row, 65, '│ Inputs from selected device:                                  │')
		row += 1
		bit_index = 0
		#pdb.set_trace()
		for row in range(row, row + (int(len(input_bits) / 4))):
			format_values = []
			#print('index: ' + str(bit_index))
			#print('to: ' + str(bit_index + 4))
			for bit_index in range(bit_index, bit_index + 4):
				#print('index: ' + str(bit_index))

				format_values.append(bit_index + 1)
				format_values.append(input_bits[bit_index] and 'x' or ' ')

			bit_index += 1

			#print(format_values)
			print_at_lock(row, 65, _inputs_format.format(*format_values))

		row += 1

	for row in range(row, 23):
		print_at_lock(row, 65, '│                                                               │')


def print_timeout(is_active=False, is_triggered=False):
	print_at_lock(23, 0, '├────────────────────────────────────────────────────────────────┴───────────────────────────────────────────────────────────────┤')
	print_at_lock(24, 0, _timeout_line_format.format(is_active and 'x' or ' ', is_triggered and 'x' or ' '))


def print_commands():
	print_at_lock(25, 0, '''\
├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ Commands:                                                                                                                      │
│ CTRL + F1 : activates all outputs             CTRL + SHIFT + 1 : deativates timeout            CTRL + R : reboot               │
│ CTRL + F2 : deactivates all outputs           CTRL + SHIFT + 2 : activates Timeout 5 sec                                       │
│ CTRL + F3 : activates outputs: 1, 3, 7        CTRL + SHIFT + 3 : activates Timeout 10 sec                                      │
│ CTRL + F4 : deactivates outputs: 1, 3, 7      CTRL + SHIFT + 4 : activates Timeout 15 sec                                      │
└────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
Press CTRL + C to stop the server

''')