import platform;
from os import system
from threading import Lock
import sys

_print_lock = Lock()

_py3 = False

if (sys.version_info > (3, 0)):
	_py3 = True


if platform.system() == 'Windows':
	from ctypes import Structure, c_char_p, c_short, windll, c_wchar_p
	from sys import stdout


	STD_OUTPUT_HANDLE = -11

	class COORD(Structure):
		pass

	COORD._fields_ = [("X", c_short), ("Y", c_short)]

	_h = windll.kernel32.GetStdHandle(STD_OUTPUT_HANDLE)
	_encoding = stdout.encoding


	def print_at(row, column, data):
		windll.kernel32.SetConsoleCursorPosition(_h, COORD(column, row))

		if not _py3:
			data = data.decode('utf-8')

		windll.kernel32.WriteConsoleW(_h, c_wchar_p(data), len(data), None, None)
		stdout.flush()

	def clear():
		system('cls')

else:
	from sys import stdout
	import curses
	import locale
	locale.setlocale(locale.LC_ALL, '')

	win = curses.initscr()

	def print_at(row, column, data):
		#stdout.write("\x1b7\x1b[%d;%df%s\x1b8" % (row+1, column+1, data))
		#stdout.flush()
		win.addstr(row, column, data)
		win.refresh()

	def clear():
		system('clear')



def print_at_lock(row, column, data):
	with _print_lock:
		print_at(row, column, data)