import threading
import pdb

class PeriodicWorker(threading.Thread):
	"""
	:param interval: Interval in milliseconds
	:type interval: int

	"""
	def __init__(self, func, stop_evt, interval=100, waitFirst=False, args=()):
		super(PeriodicWorker, self).__init__()
		self._stop_evt = stop_evt or threading.Event()
		

		self._own_stop_evt = not stop_evt

		self._func = func
		self._interval = interval / 1000.0
		self._args = args
		self._waitFirst = waitFirst

	def run(self):
		while True:
			if self._waitFirst:
				if self._stop_evt.wait(self._interval):
					break				

			self._func(*self._args)

			if not self._waitFirst:
				if self._stop_evt.wait(self._interval):
					break

	def stop(self):
		if self._own_stop_evt:
			self._stop_evt.set()
