﻿Imports System.Collections.Generic
Imports System.Linq
Imports System.Threading.Tasks
Imports YMLib

Public Class frmMain_USB_REL_16
    Private YMcom As DeviceServer = New DeviceServer()
    Private _closing As Boolean
    Dim SendeByte1, SendeByte2 As Byte

    Private Sub TestForm_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        warningLabel.Text = ""
        YMcom = New DeviceServer With
        {
            .DeviceConnectedCallback = AddressOf DeviceConnectedCallback,
            .DeviceDisconnectedCallback = AddressOf DeviceDisconnectedCallback,
            .DevicesChangedCallback = AddressOf DevicesChangedCallback,
            .ReadAllDevicesContinuously = True,
            .ReadAllDevicesInterval = 1,
            .ReadCallback = AddressOf ReadCallback
        }

        YMcom.StartAsync()

    End Sub

    Private Function DeviceConnectedCallback(device As Device) As Task
        Debug.WriteLine("****Device Connected: " & device.Adresse)
        Return Task.FromResult(Of Integer)(0)
    End Function

    Private Function DeviceDisconnectedCallback(device As Device) As Task
        Debug.WriteLine("****Device Disconnected: " & device.Adresse)
        Return Task.FromResult(Of Integer)(0)
    End Function

    Private Function DevicesChangedCallback(connectedDevices As List(Of Device), disconnectedDevices As List(Of Device), currentConnectedDevices As List(Of Device)) As Task
        Debug.WriteLine("****Devices Changed: ")
        Dim adresses As Integer() = currentConnectedDevices.Select(Function(d) d.Adresse).ToArray()
        Dim duplicates As List(Of String) = adresses.GroupBy(Function(s) s).Where(Function(g) g.Count() > 1).Select(Function(g) g.Key.ToString()).ToList()

        Invoke(Sub()
                   Dim selectedAdresse As Integer = -1

                   If ComboBox1.SelectedIndex > -1 Then
                       selectedAdresse = Convert.ToInt32(ComboBox1.SelectedValue)
                   End If
                   ComboBox1.Text = ""
                   ComboBox1.Items.Clear()
                   For Each adresse As Integer In adresses
                       ComboBox1.Items.Add(adresse.ToString())
                   Next

                   If selectedAdresse > -1 AndAlso currentConnectedDevices.Any(Function(d As Device) d.Adresse = selectedAdresse) Then
                       ComboBox1.SelectedValue = selectedAdresse.ToString()
                   End If

                   If currentConnectedDevices.Count > 0 Then
                       'Dim duplicates As List(Of String) = currentConnectedDevices.GroupBy(Function(s) s.Adresse).Where(Function(g) g.Count() > 1).Select(Function(g) g.Key.ToString()).ToList()
                       If duplicates.Count > 0 Then
                           warningLabel.Text = "Duplicated Addressen: " & String.Join(", ", duplicates) & vbCrLf & "Writing and Reading is only possible for unique addresses"
                       Else
                           warningLabel.Text = ""
                       End If

                   End If
               End Sub)

        Return Task.FromResult(Of Integer)(0)
    End Function

    Private Sub _UpdateChechboxes(readData As ReadData)
        SendeByte1 = readData.RelaisCount1
        SendeByte2 = readData.RelaisCount2



        For i As Integer = 0 To 7
            myCheckBoxen1(i).Checked = (readData.RelaisCount1 And 1 << i) > 0
            myCheckBoxen2(i).Checked = (readData.RelaisCount2 And 1 << i) > 0
        Next i


        If readData.Isttimeraktiviert = 1 Then
            cmbSek.SelectedIndex = readData.Zt_Reset
            Label11.Text = "Timeout has been set"
            chkTimeOut.CheckState = 1
            GroupBox4.Enabled = False
            cmbSek.Enabled = False
        Else
            Label11.Text = "Timeout was not set"
            chkTimeOut.CheckState = 0
            GroupBox4.Enabled = True
            cmbSek.Enabled = True
        End If

        If readData.Timeout_ausgeloest = 1 Then
            btnResetTimeout.Enabled = True
            Label24.ForeColor = Color.DarkRed
            Label24.Text = "Timeout is triggered"
        Else
            btnResetTimeout.Enabled = False
            Label24.ForeColor = Color.Black
            Label24.Text = "No Timeout"
        End If


    End Sub

    Private Function ReadCallback(device As Device, readData As ReadData) As Task
        Debug.WriteLine("ReadData from device: " & device.Adresse)

        Invoke(Sub()
                   Dim index As Integer = ComboBox1.SelectedIndex
                   Dim text As String = ComboBox1.Text


                   If (index > -1 AndAlso Not String.IsNullOrEmpty(text)) Then

                       Dim selectedAdresse As Integer = Convert.ToInt32(text)

                       Debug.WriteLine("selected2: " & selectedAdresse)

                       If (selectedAdresse = device.Adresse) Then
                           _UpdateChechboxes(readData)
                       End If
                   End If

               End Sub)

        Return Task.FromResult(Of Integer)(0)
    End Function


#Region "User Action"
    Private Sub ComboBox1_SelectedIndexChanged(sender As Object, e As EventArgs) Handles ComboBox1.SelectedIndexChanged
        If ComboBox1.SelectedIndex > -1 Then
            Dim device As Device = YMcom.GetDevice(Convert.ToInt32(ComboBox1.Text))
            If device IsNot Nothing Then
                txtProduktName.Text = device.Definition.ProductName
                txtSerialNr.Text = device.Definition.SerialNumber
            End If
        End If
    End Sub

    Private Sub btnAllON_Click(sender As Object, e As EventArgs) Handles btnAllON.Click

        SendeByte1 = 255
        SendeByte2 = 255

        SchaltZustandSenden()
    End Sub
    Private Sub btnAllOFF_Click(sender As Object, e As EventArgs) Handles btnAllOFF.Click

        SendeByte1 = 0
        SendeByte2 = 0

        SchaltZustandSenden()
    End Sub
    Private Sub Checkbox1_Click(sender As Object, e As EventArgs) Handles Checkbox1.Click, CheckBox2.Click, CheckBox3.Click, CheckBox4.Click, CheckBox5.Click, CheckBox6.Click, CheckBox7.Click, CheckBox8.Click
        Dim myCheckBoxRelKanal As CheckBox = DirectCast(sender, CheckBox)

        If myCheckBoxRelKanal.CheckState = 1 Then
            SendeByte1 += CInt(myCheckBoxRelKanal.Tag)
        Else
            SendeByte1 -= CInt(myCheckBoxRelKanal.Tag)
        End If
        SchaltZustandSenden()

    End Sub
    Private Sub Checkbox9_Click(sender As Object, e As EventArgs) Handles CheckBox9.Click, CheckBox10.Click, CheckBox11.Click, CheckBox12.Click, CheckBox13.Click, CheckBox14.Click, CheckBox15.Click, CheckBox16.Click
        Dim myCheckBoxRelKanal As CheckBox = DirectCast(sender, CheckBox)

        If myCheckBoxRelKanal.CheckState = 1 Then
            SendeByte2 += CInt(myCheckBoxRelKanal.Tag)
        Else
            SendeByte2 -= CInt(myCheckBoxRelKanal.Tag)
        End If
        SchaltZustandSenden()

    End Sub

    Private Sub AboutBox_Click(sender As Object, e As EventArgs) Handles AboutBox.Click
        YMcom.CALL_ABOUT_BOX()
    End Sub

    Private Sub btnResetTimeout_Click(sender As Object, e As EventArgs) Handles btnResetTimeout.Click
        HW_Reset()
    End Sub

    Private Sub btnAll_Channel_ON_Click(sender As Object, e As EventArgs) Handles btnAll_Channel_ON.Click
        For i As Integer = 0 To 1
            myChannel(i).Text = "255"
        Next
    End Sub
    Private Sub btnAll_Channel_OFF_Click(sender As Object, e As EventArgs) Handles btnAll_Channel_OFF.Click
        For i As Integer = 0 To 1
            myChannel(i).Text = "0"
        Next
    End Sub

    Private Sub chkTimeOut_Click(sender As Object, e As EventArgs) Handles chkTimeOut.Click
        If ComboBox1.Text = "" Then
            chkTimeOut.Checked = False
            Exit Sub
        End If

        'If YMcom.YM_TimeOutTriggered = 1 Then
        '    chkTimeOut.Checked = False
        'End If

        'If YMcom.YM_TimeOutTriggered = 0 Then
        If chkTimeOut.Checked Then
                cmbSek.Enabled = False
                btnResetTimeout.Enabled = False
                GroupBox4.Enabled = False

            'TimeOut wird aktiviert, der Interval wird festgelegt und die Kanäle werden definiert, welches beim TIMEOUT Auslösung 
            'eingeschaltet bzw. ausgeschaltet werden sollen. 
            'Die Zeiten von 5s bis 53s werden durch den Index der ComboBox von 0-48 festgelegt.

            YMcom.TIMEOUT_INTERVAL_AND_CHANNEL_16(CInt(ComboBox1.Text), CByte(cmbSek.SelectedIndex), CByte(txtch1.Text), CByte(txtch2.Text))

        ElseIf Not chkTimeOut.Checked Then

                cmbSek.Enabled = True
                btnResetTimeout.Enabled = True
                GroupBox4.Enabled = True

                'TimeOut wird deaktiviert
                TIMEOUT_DISABLE()

            End If
        'End If
    End Sub
#End Region

    Private Sub TIMEOUT_DISABLE()
        Try
            YMcom.TIMEOUT_DISABLE(ComboBox1.Text)
            WriteOutput.Text = "Succeeded"
        Catch ex As Exception
            WriteOutput.Text = "error or no device found by adresse" & "/" & ex.Message
        End Try
    End Sub

    Private Sub chkTimeOut_CheckedChanged(sender As Object, e As EventArgs) Handles chkTimeOut.CheckedChanged

    End Sub

    Private Sub HW_Reset()
        Try
            YMcom.HW_RESET(ComboBox1.Text)
            WriteOutput.Text = "Succeeded"
        Catch ex As Exception
            WriteOutput.Text = "error or no device found by adresse" & "/" & ex.Message
        End Try
    End Sub
    Private Sub SchaltZustandSenden()
        Try
            YMcom.SEND_OUTPUT_STATUS_16(ComboBox1.Text, SendeByte1, SendeByte2)
            WriteOutput.Text = "Succeeded"
        Catch ex As Exception
            WriteOutput.Text = "error or no device found by adresse" & "/" & ex.Message
        End Try
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick

    End Sub

    Private Sub TestForm_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        If _closing Then
            Exit Sub
        End If

        _closing = True

        Debug.WriteLine("form closing...")
        e.Cancel = True
        Dim task As Task = YMcom.StopAsync()
        task.ContinueWith(Sub(t)
                              Invoke(Sub()
                                         Me.Close()
                                     End Sub)
                          End Sub)
    End Sub




End Class